#include <iostream>
#include <vector>
#include <set>
#include <queue>
#include <algorithm>
#include <map>
using namespace std;
typedef long long ll;
const int MAKS_N = 200005;
int N, Q;
int niz_karata[MAKS_N];
set<int> pozicije[MAKS_N];
ll suma_po_vrednosti[MAKS_N];
ll ukupna_suma_svih_karata = 0;
set<int> aktivne_vrednosti;
struct Dogadjaj {
    int vreme;
    ll tezina;
    bool operator<(const Dogadjaj& other) const {
        return vreme < other.vreme;}};
void resi() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cin >> N >> Q;
    for (int i = 1; i <= N; i++) {
        cin >> niz_karata[i];
        if (pozicije[niz_karata[i]].empty()) {
            aktivne_vrednosti.insert(niz_karata[i]);}
        pozicije[niz_karata[i]].insert(i);
        suma_po_vrednosti[niz_karata[i]] += niz_karata[i];
        ukupna_suma_svih_karata += niz_karata[i];}
    vector<Dogadjaj> lista_dogadjaja;
    lista_dogadjaja.reserve(N);
    for (int i = 0; i < Q; i++) {
        int tip_upita;
        cin >> tip_upita;
        if (tip_upita == 1) {
            int k;
            cin >> k;
            if (k >= N) {
                cout << ukupna_suma_svih_karata << "\n";
                continue;}
            lista_dogadjaja.clear();
            for (int vrednost : aktivne_vrednosti) {
                int poslednji_indeks = *pozicije[vrednost].rbegin();
                int trenutak = max(poslednji_indeks, k + 1);
                if (trenutak <= N) {
                    lista_dogadjaja.push_back({trenutak, suma_po_vrednosti[vrednost]});}}
            sort(lista_dogadjaja.begin(), lista_dogadjaja.end());
            priority_queue<ll> prioritetni_red;
            ll maksimlana_uklonjena_suma = 0;
            int idx_dogadjaja = 0;
            int broj_dogadjaja = lista_dogadjaja.size();
            for (int potez = k + 1; potez <= N; potez++) {
                while (idx_dogadjaja < broj_dogadjaja && lista_dogadjaja[idx_dogadjaja].vreme <= potez) {
                    prioritetni_red.push(lista_dogadjaja[idx_dogadjaja].tezina);
                    idx_dogadjaja++;}
                if (!prioritetni_red.empty()) {
                    maksimlana_uklonjena_suma += prioritetni_red.top();
                    prioritetni_red.pop();}}
            cout << (ukupna_suma_svih_karata - maksimlana_uklonjena_suma) << "\n";
        } else {
            int pozicija, nova_vrednost;
            cin >> pozicija >> nova_vrednost;
            int stara_vrednost = niz_karata[pozicija];
            if (stara_vrednost == nova_vrednost) continue;
            pozicije[stara_vrednost].erase(pozicija);
            suma_po_vrednosti[stara_vrednost] -= stara_vrednost;
            ukupna_suma_svih_karata -= stara_vrednost;
            if (pozicije[stara_vrednost].empty()) {
                aktivne_vrednosti.erase(stara_vrednost);}
            niz_karata[pozicija] = nova_vrednost;
            if (pozicije[nova_vrednost].empty()) {
                aktivne_vrednosti.insert(nova_vrednost);}
            pozicije[nova_vrednost].insert(pozicija);
            suma_po_vrednosti[nova_vrednost] += nova_vrednost;
            ukupna_suma_svih_karata += nova_vrednost;}}}
int main() {
    resi();
    return 0;
}